import { Providers } from "@/components/providers";
import "./styles/globals.css"

import { mono, sans } from "@/config/fonts";

export { metadata } from "@/config/site"

import outputs from '@/../amplify_outputs.json';
import { Amplify } from 'aws-amplify';
import ConfigureClientSideAmplify from "@/features/auth/components/configure-client-side.amplify";
Amplify.configure(outputs, { ssr: true });

export default function RootLayout({
  children,
}: Readonly<{
  children: React.ReactNode;
}>) {
  return (
    <html lang="en" suppressHydrationWarning>
      <body
        className={`${sans.variable} ${mono.variable} antialiased grid min-h-svh`}
      >
        <Providers>
          <ConfigureClientSideAmplify />
          {children}
        </Providers>
      </body>
    </html>
  );
}
